
/***************************************************************** 
* WARNING: This file is automatically generated. DO NOT EDIT IT!
*
* COPYRIGHT (c) Freescale 2004-2014, All Rights Reserved
*
* FILE NAME: etpu_set.h
* ARCHITECTURE: eTPU2
*
* This file was generated by: etpuc_set.c on Dec  2 2015 , 13:47:34
*
*****************************************************************/
#ifndef _ETPU_SET_H_
#define _ETPU_SET_H_

/***************************************************************** 
* Function Set Definitions
*****************************************************************/
#define FS_ETPU_ENTRY_TABLE 0x0000
#define FS_ETPU_MISC 0xb5dbac9f
#define FS_ETPU_ENGINE_MEM_SIZE 0x50
#define FS_ETPU_ARCHITECTURE ETPU2

/***************************************************************** 
* Global Error Definitions
*****************************************************************/
#define FS_ETPU_GLOBAL_ERROR_CHANNEL_MASK 0x00FFU
#define FS_ETPU_GLOBAL_ERROR_EVENT_MASK 0xFF00U
#define FS_ETPU_GLOBAL_ERROR_EVENT_LSR 0x0100U
#define FS_ETPU_GLOBAL_ERROR_EVENT_MRLA 0x0200U
#define FS_ETPU_GLOBAL_ERROR_EVENT_MRLB 0x0400U
#define FS_ETPU_GLOBAL_ERROR_EVENT_TDLA 0x0800U
#define FS_ETPU_GLOBAL_ERROR_EVENT_TDLB 0x1000U
#define FS_ETPU_GLOBAL_ERROR_EVENT_PSS 0x2000U
#define FS_ETPU_GLOBAL_ERROR_EVENT_FLAG0 0x4000U
#define FS_ETPU_GLOBAL_ERROR_EVENT_FLAG1 0x8000U

#define FS_ETPU_OFFSET_GLOBAL_ERROR 0x31

/***************************************************************** 
* Initialization values of global variables
* On eTPU(2) initialization, this array must be copied
* into the eTPU DATA RAM from its start address.
*****************************************************************/
const uint32_t etpu_globals[] = {
0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
0x000000ff
};

/***************************************************************** 
* Image of the compiled eTPU code binary
* On eTPU(2) initialization, this array must be copied
* into the eTPU CODE RAM.
*****************************************************************/
const uint32_t etpu_code[] = {

0x408e408e, 0x408e408e, 0x48154815, 0x48154815, 
0x48150080, 0x408e408e, 0x40964096, 0x40964096, 
0x48154815, 0x48154815, 0x40a540a5, 0x40a540a5, 
0x408e408e, 0x408e408e, 0x408e408e, 0x408e408e, 
0x48154815, 0x48154815, 0x0133011f, 0x48154815, 
0x48154815, 0x48154815, 0x48154815, 0x48154815, 
0x48154815, 0x48154815, 0x48154815, 0x48154815, 
0x4137430d, 0x4137430d, 0x4137430d, 0x4137430d, 
0x05120512, 0x05120512, 0x05100508, 0x48154815, 
0x45244524, 0x45244524, 0x45244524, 0x45244524, 
0x48154815, 0x48154815, 0x48154815, 0x48154815, 
0x45244524, 0x45244524, 0x45244524, 0x45244524, 
0x064b0652, 0x064b0652, 0x0644062b, 0x062b062b, 
0x05f90658, 0x05f90658, 0x05f90658, 0x05f90658, 
0x05bd05bd, 0x05dc065a, 0x05bd05bd, 0x05dc065a, 
0x05f90658, 0x05f90658, 0x05f90658, 0x05f90658, 
0x07460746, 0x07460746, 0x0734071b, 0x071b071b, 
0x07480787, 0x07480787, 0x07480787, 0x07480787, 
0x07ae07ae, 0x07a5078a, 0x07ae07ae, 0x07a5078a, 
0x07480787, 0x07480787, 0x07480787, 0x07480787, 
0x48154815, 0x48154815, 0x07e287d3, 0x87d387d3, 
0x48154815, 0x48154815, 0x48154815, 0x48154815, 
0x87e787f9, 0x87e78802, 0x87e787f9, 0x87e78802, 
0x87e787f9, 0x87e78802, 0x87e787f9, 0x87e78802, 
0x08b908b9, 0x08b908b9, 0x481508b2, 0x08b208b2, 
0x48150909, 0x481508ec, 0x48150909, 0x481508ec, 
0x08df8900, 0x08e94815, 0x08df8900, 0x08e94815, 
0x09168900, 0x08e908ec, 0x09168900, 0x08e908ec, 
0x48154815, 0x48154815, 0x48150922, 0x48154815, 
0x093b093b, 0x093b093b, 0x093b093b, 0x093b093b, 
0x098b098b, 0x098b098b, 0x098b098b, 0x098b098b, 
0x093b093b, 0x093b093b, 0x093b093b, 0x093b093b, 
0xfb775cfb, 0xf3b01107, 0x4ff227f9, 0xf3d010c7, 
0xf7f01187, 0x5b7fffff, 0xf7f01187, 0x593fffff, 
0xf3d01167, 0xf7f01187, 0x5a5fffff, 0x581fffff, 
0x481fffff, 0xf73ffcfb, 0xbffb7a82, 0x4ffff7ff, 
0xf0f012a7, 0xbffffb01, 0xcfef3980, 0x0c02aba2, 
0xcffff980, 0x0fffffff, 0xbfeb0f80, 0x7c69fffb, 
0xf0901467, 0xbdf97b81, 0x1c094b8a, 0xbfefab83, 
0x1f1b0fff, 0xf4301407, 0x00094419, 0x000fa439, 
0xfffff9d9, 0x00094439, 0x0ffe7bdf, 0x0c02abc2, 
0xc7ff3980, 0xbfeb0f80, 0x7c69fffb, 0xf0901827, 
0xbdf97b81, 0x1c094b8a, 0xbfefab83, 0x1f1b0fff, 
0xf47015e7, 0x00094419, 0x000fa439, 0xfffff9d9, 
0x00094439, 0x1ffe7bdf, 0xbfeffb81, 0xbfa83f80, 
0x1c73feef, 0xf09017c7, 0xbdd37b81, 0x000fa419, 
0xf4301767, 0x00194419, 0x000fa439, 0xfffff9d9, 
0x00194439, 0x0ff37bdf, 0xcfef3980, 0x0c02abc2, 
0xc7fff980, 0x0c02abc2, 0xc7ff3980, 0x1c09778a, 
0x2b14ffe9, 0xf35818a7, 0x7ff44ebf, 0x1f7e4fff, 
0x00070409, 0x7c3b2f7f, 0x1c09478a, 0x7f7e3fdf, 
0x6fefffff, 0xbfefff8a, 0x2b3bffe9, 0xf35819e7, 
0x00077409, 0xcfeff981, 0x3ff24bf4, 0x000b4439, 
0x2b79ffe8, 0xf3581aa7, 0x00084409, 0x1f7e4fff, 
0x1f783fff, 0xbfefff89, 0x2b3bffe9, 0xf3581b67, 
0x7ff71e8f, 0x1f3e4fff, 0x7c5b2f7f, 0x6fefffff, 
0x7ffc2e3f, 0x6ff93fdf, 0x1c09778a, 0x2b14ffe9, 
0xf3581c87, 0x7ff44ebf, 0x1f7e4fff, 0x7ffc2f7f, 
0x6f773fcf, 0xcfeff988, 0x0c22ab82, 0xcffff988, 
0x000fa479, 0xcffff987, 0x00800418, 0xffff3959, 
0xcfeff88f, 0xffd10527, 0xcfeff890, 0xffd10527, 
0xcfeff891, 0xffd10527, 0xcfeff892, 0xffd10527, 
0x00080418, 0x1c7dfeff, 0x1effefff, 0xf0b01fc7, 
0x000f2411, 0x00029409, 0x9feffb09, 0x9ffffb0a, 
0xcffff804, 0xcffff805, 0xbffffb03, 0x6ffc2e3f, 
0xf3902167, 0xbfeffb93, 0xcfeff985, 0x1ef24fff, 
0x1c0b4b8a, 0x1f784fff, 0x1ff97bdf, 0xffdfccf9, 
0x00077409, 0xcdfff288, 0x00087409, 0xcdfff289, 
0xbfeffb81, 0x2b19ffee, 0xf3582247, 0x10087f8e, 
0x1c080bca, 0x10077f8e, 0x1c084bca, 0xbfeffb81, 
0x2b1bffee, 0xf3582327, 0x1f38efef, 0xcdeff289, 
0x00088411, 0xcdefc288, 0x00087411, 0xfb775cfb, 
0xf3f02467, 0x5a1027f1, 0x59ffffff, 0xcfe8f981, 
0x1002f782, 0xf0f02507, 0x481fffff, 0x0ffffefe, 
0x000d4419, 0x1c7ffeff, 0x1effefff, 0xf4b025c7, 
0x000f2411, 0x00029409, 0x00800418, 0xfffff959, 
0x9dec2b09, 0xdf3fb20a, 0xc7fff907, 0xbfeffb87, 
0x000fa479, 0x1f1d9fff, 0xc7fff108, 0xcfeff987, 
0x00200478, 0xf2305427, 0x00020419, 0x7c69fffb, 
0xf4d053c7, 0xbf863f7f, 0x00400504, 0x3f796fd9, 
0x1f167fef, 0x3f786fda, 0xffffccf9, 0x00036401, 
0xf7d02a07, 0xf7d05367, 0xf7d02ac7, 0xf7d02bc7, 
0xf7d02c87, 0xf7d03067, 0xf7d03527, 0xf7d03cc7, 
0xf7d03c87, 0xf7d041c7, 0xf7d05367, 0xf7d045e7, 
0x000fa439, 0xcffff987, 0xbfef9b80, 0x58ffffff, 
0xfff01c07, 0x1f1e0fff, 0xcfeff986, 0x1ef2afff, 
0x0002f019, 0x000f9419, 0xf0f06187, 0xcffff986, 
0x000fa479, 0xc7fff987, 0x001fa419, 0xcffff987, 
0xbffe7b83, 0xbfef9b8d, 0xfff01c07, 0x1f1e0fff, 
0x001fa439, 0xcffff987, 0xbfef9b83, 0xcdfff080, 
0x1c1e0fff, 0x00097419, 0xcdfff28b, 0xbffe7b83, 
0xcdfff681, 0xcdeff681, 0xcdeff28b, 0xbffffb84, 
0xbfeffb8a, 0xcdfff681, 0xcdeff68b, 0x2b78ffe9, 
0xcdeff681, 0xf3582ea7, 0xcfeff981, 0x3ff20bf4, 
0xcdfff681, 0xcdeff68b, 0x00090439, 0x00073401, 
0x2b3bffe8, 0xcdeff681, 0xf3582fc7, 0x00080409, 
0x1f3e0fff, 0xfff01c07, 0x1f330fef, 0xbfef9b83, 
0xcdfff080, 0x1c1e0fff, 0x00097419, 0xcdfff28b, 
0xcdeff080, 0xbffe7b83, 0xbfeffb88, 0xcdfff681, 
0xcdeff68b, 0x2b78ffe9, 0xcdeff681, 0xf35831e7, 
0xbfeffb84, 0x1c17feef, 0xf4d83467, 0xcdfff681, 
0xcdeff28b, 0xcdeff681, 0xbffffb84, 0xcfeff981, 
0x3ff20bf4, 0x00090439, 0x2b38ffee, 0xf3583367, 
0xbfd87b85, 0x001fa459, 0xcffff987, 0xbfeffb8b, 
0xb7e80b85, 0xfff01867, 0x00085411, 0xcdfff681, 
0xcdeff68b, 0x000b0419, 0xcdeff681, 0xbff97b84, 
0xffd019ad, 0xbfeffb83, 0x1c1e0fff, 0xcdfff080, 
0x00097419, 0xcdfff28b, 0xbffe7b83, 0xbfeffb84, 
0xbfe80b88, 0x2b38ffe9, 0xf3583647, 0xcdfff681, 
0xcdeff68b, 0x1c77feef, 0xf4f83b87, 0xcdeff681, 
0x001fa479, 0xcffff987, 0xcdfff681, 0xcdeff28b, 
0xcdeff681, 0xb1ffab84, 0xcffff885, 0x000fa439, 
0xcffff984, 0x0002a439, 0xcffff984, 0xbfeffb81, 
0x1c080392, 0x1ef90fff, 0x03f004f4, 0x2f591ff2, 
0x1c000f08, 0xcdfff681, 0x3f322f92, 0xcdeff68b, 
0x3f522f90, 0xfff02187, 0x000b0419, 0xbdefab81, 
0x00800418, 0xffff39d9, 0x00089419, 0xfff10527, 
0xcfeff88e, 0xbfeffb89, 0xcdfff681, 0xcdeff68b, 
0x000b5411, 0x1c080792, 0xfff01867, 0xcdeff681, 
0x001fa439, 0xcffff987, 0xcdfff681, 0xcdeff68b, 
0x000b0419, 0xcdeff681, 0xbff97b84, 0xffd019ad, 
0x001fa479, 0xcffff987, 0xbfeffb83, 0xcdfff080, 
0x1c1e0fff, 0x00097419, 0xcdfff28b, 0xbffe7b83, 
0xcdfff681, 0xcfeff984, 0xcdeff28b, 0xcdeff681, 
0x0002a439, 0xcffff884, 0xcfeff985, 0x0002a439, 
0xcffff885, 0xcfeff984, 0x00023411, 0xcfeff980, 
0x1ef20fff, 0x1c33feef, 0xf0d03fa7, 0x002fa439, 
0xcffff987, 0xcdfff681, 0xcdeff68b, 0x000b0419, 
0xfff02187, 0xcdeff681, 0xcdfff681, 0xcdeff68b, 
0x000b0419, 0xfff02087, 0xcdeff681, 0xbfeffb89, 
0xcdfff681, 0xcdeff68b, 0x000b5411, 0x1c080792, 
0xfff01867, 0xcdeff681, 0xbfeffb83, 0xcdfff080, 
0x1c1e0fff, 0x00097419, 0xcdfff28b, 0xbffe7b83, 
0xcdfff681, 0xcdeff68b, 0xcfeff984, 0x000b0419, 
0xcdeff681, 0x0002a439, 0x00097419, 0xcffff884, 
0xcfeff985, 0x0002a439, 0xfff02187, 0xcffff885, 
0xcdfff681, 0xcdeff68b, 0x000b0419, 0xfff02087, 
0xcdeff681, 0x002fa479, 0xcffff987, 0xcfeff894, 
0xcdfff681, 0x00060419, 0xcdeff68b, 0x3f322f90, 
0x000b0419, 0xfff019a7, 0xcdeff681, 0xbfeffb83, 
0xcdfff080, 0x1c1e0fff, 0x00097419, 0xcdfff28b, 
0xbffe7b83, 0xbfeffb88, 0xcdfff681, 0xcdeff68b, 
0x2b78ffe9, 0xcdeff681, 0xf3584747, 0xbfeffb84, 
0x1c17feef, 0xf4d85267, 0xcdfff681, 0xcdeff28b, 
0xbffffb84, 0xcfeff981, 0x3ff20bf4, 0x00090439, 
0x2b38ffee, 0xf35848a7, 0xbfd87b85, 0xfff02187, 
0x00080419, 0x002fa419, 0xcffff987, 0x000fa439, 
0xcffff984, 0xcfeff985, 0x00020419, 0xcfeff981, 
0x3f320bf4, 0xf7f04aa7, 0x0ff91bfa, 0xffe0208d, 
0x00080419, 0xcfeff985, 0x0002a439, 0x1c52feff, 
0xf4f84a67, 0xcffff985, 0x00800418, 0xffeff9d9, 
0x00020419, 0x0809fbaa, 0xf0d84c87, 0x0809fbca, 
0xf0d84e07, 0x0809fbea, 0xf0d84fc7, 0xf7d051a7, 
0xcfeff985, 0x00020419, 0xcfeff983, 0x00027419, 
0x1c19feff, 0xf09851a7, 0x000fa459, 0xffff39d9, 
0x000fa439, 0x000f9419, 0xf7f051a7, 0xcffff985, 
0xcfeff985, 0x00020419, 0xcfeff983, 0x00027419, 
0x1c19feff, 0xf09851a7, 0x000fa439, 0xffff39d9, 
0xfff10527, 0xcfeff88e, 0x000fa439, 0xcffff985, 
0xf7f051a7, 0x000f9419, 0xcfeff985, 0x00020419, 
0xcfeff982, 0x00027419, 0x1c19feff, 0xf09851a7, 
0xfff10527, 0xceeff88e, 0x000fa439, 0xcffff985, 
0x9fefff0a, 0x9feffb09, 0x1f1b7fff, 0x00a00438, 
0x1ffffbdf, 0xffe0208d, 0x00080419, 0xbfeffb8b, 
0xb7e80b85, 0xfff01867, 0x00085411, 0xcdfff681, 
0xcdeff28b, 0xbffffb84, 0xbffffb85, 0xcfeff988, 
0x0e02ab82, 0xfff01d27, 0xcffff988, 0xcfeff988, 
0x0c02aba2, 0xc7fff988, 0xcfeff988, 0x0c42ab82, 
0xc7fff988, 0x7c79ffbb, 0xf4d06127, 0xbf863f7f, 
0x02a00680, 0x3f796fd9, 0x1f167fef, 0x3f786fda, 
0xffffccf9, 0x00036401, 0xf7d060c7, 0xf7d056c7, 
0xf7d060c7, 0xf7d060c7, 0xf7d05867, 0xf7d05867, 
0xf7d05867, 0xf7d05947, 0xf7d05e87, 0xf7d05ea7, 
0xf7d05f27, 0xf7d06047, 0xf3f05747, 0x000f9419, 
0xf7f05767, 0x59ffffff, 0x5affffff, 0x71ffaeff, 
0xcffff987, 0xcfeff986, 0x0002f019, 0xf0f06187, 
0x7ffc2f7f, 0x000fa479, 0xc7fff987, 0xdfef5988, 
0x0c12ab82, 0xcffff988, 0x7ffc2f7f, 0x000fa479, 
0x000f9419, 0xc7fff987, 0xcfeff988, 0x0c12ab82, 
0xcffff988, 0x002fa419, 0xcffff987, 0xcfeff884, 
0xcdfff080, 0xcdfff28b, 0xcdeff080, 0xbde2ab83, 
0xcdfff681, 0xcdeff68b, 0x1f782fff, 0xcdeff681, 
0xbffe7b83, 0xcffff984, 0xcfeff985, 0x0002a439, 
0xcffff985, 0xcfeff984, 0x00000430, 0x00300408, 
0x00023411, 0x180af792, 0xcfeff980, 0x3f322f9c, 
0x1c520fff, 0x1c33feef, 0xf0d05d27, 0x002fa439, 
0xcffff987, 0xcdfff681, 0xcdeff68b, 0x000b0419, 
0xfff02087, 0xcdeff681, 0xbfeffb8c, 0xcdfff681, 
0xcdeff68b, 0x1c080792, 0xfff01867, 0x000b5411, 
0xffd01d27, 0xcfeff988, 0x0c82ab82, 0xfff01d27, 
0xcffff988, 0x002fa479, 0xcffff987, 0xcfeff894, 
0xbfe60b83, 0xbfe82b84, 0x3f322f90, 0x4fff2fff, 
0xfff019a7, 0x00080419, 0xcfeff988, 0x0d02ab82, 
0xfff01d27, 0xcffff988, 0xcfeff988, 0x0c02abc2, 
0xc7fff988, 0xcfeff988, 0x0c42ab82, 0xcffff988, 
0x0fffffff, 0xcfeff987, 0x00200478, 0xf2309427, 
0x00020419, 0x7c69fffb, 0xf4d093c7, 0xbf863f7f, 
0x01a00700, 0x3f796fd9, 0x1f167fef, 0x3f786fda, 
0xffffccf9, 0x00036401, 0xf7d064c7, 0xf7d09367, 
0xf7d06587, 0xf7d06687, 0xf7d06747, 0xf7d06867, 
0xf7d06dc7, 0xf7d075a7, 0xf7d07567, 0xf7d07aa7, 
0xf7d07fe7, 0xf7d08607, 0x000fa439, 0xcffff987, 
0xbfef9b80, 0x58ffffff, 0xfff01c07, 0x1f1e0fff, 
0xcfeff986, 0x1ef2afff, 0x0002f019, 0x000f9419, 
0xf0f0a0e7, 0xcffff986, 0x000fa479, 0xc7fff987, 
0x001fa419, 0xcffff987, 0xbffe7b83, 0xbfef9b8d, 
0xfff01c07, 0x1f1e0fff, 0x001fa439, 0xcffff987, 
0xbfef9b83, 0x1c1e3ff7, 0xbffe7b83, 0xbfd37b84, 
0xbf835b89, 0xfff01c47, 0x1c080792, 0xbfef9b83, 
0x1c1e0fff, 0xcdfff080, 0x00097419, 0xcdfff28b, 
0xcdeff080, 0xbfeffb84, 0xbfe80b88, 0x2b38ffe9, 
0xf3586987, 0xcdfff681, 0xcdeff68b, 0x1c77feef, 
0xf4f86c27, 0xcdeff681, 0xcdfff681, 0xcdeff28b, 
0xcdeff681, 0xbffffb86, 0x001fa459, 0xcffff987, 
0xbfeffb84, 0xbfe80b89, 0x2b38ffe9, 0xf3586b67, 
0xbfeffb83, 0xbfe80b84, 0x1f190fff, 0xfff01c07, 
0x1f370fef, 0xbffe7b83, 0xcdfff681, 0xcdeff681, 
0xcdeff28b, 0xbffffb84, 0xbffffb85, 0xbfeffb89, 
0xcdfff681, 0xcdeff68b, 0x000b5411, 0x1c080792, 
0xfff01c47, 0xcdeff681, 0xbfeffb83, 0xcdfff080, 
0x1c1e0fff, 0x00097419, 0xcdfff28b, 0xbffe7b83, 
0xbfeffb88, 0xcdfff681, 0xcdeff68b, 0x2b78ffe9, 
0xcdeff681, 0xf3586f27, 0xbfeffb86, 0x1c17feef, 
0xf4d873e7, 0x001fa479, 0xcffff987, 0xcdfff681, 
0x00000430, 0xcdeff28b, 0xcdeff681, 0x000aa419, 
0xcffff884, 0xcffff885, 0xbfeffb81, 0x1c080392, 
0x1c590fff, 0x03f004f4, 0x2f591ff2, 0x1c000f08, 
0xcdfff681, 0x3f322f92, 0xcdeff68b, 0x3f522f90, 
0xfff02187, 0x000b0419, 0x00800418, 0x000fa439, 
0xffff39d9, 0x000f9419, 0xfff10527, 0xcfeff88e, 
0xbfeffb89, 0xcdfff681, 0xcdeff68b, 0x000b5411, 
0x1c080792, 0xfff01867, 0xcdeff681, 0x001fa439, 
0xcffff987, 0xbfeffb86, 0xcdfff681, 0xcdeff68b, 
0x1c1b3ff7, 0xcdeff681, 0xbfd37b84, 0xbf935b85, 
0xbfeffb89, 0xfff01c47, 0x1c080792, 0x001fa479, 
0xcffff987, 0xbfeffb83, 0xcdfff080, 0x1c1e0fff, 
0x00097419, 0xcdfff28b, 0xbffe7b83, 0xcdfff681, 
0xcfeff984, 0xcdeff28b, 0xcdeff681, 0x0002a439, 
0xcffff884, 0xcfeff985, 0x0002a439, 0xcffff885, 
0xcfeff984, 0x00023411, 0xcfeff980, 0x1ef20fff, 
0x1c33feef, 0xf0d07887, 0x002fa439, 0xcffff987, 
0xcdfff681, 0xcdeff68b, 0x000b0419, 0xfff02187, 
0xcdeff681, 0xcdfff681, 0xcdeff68b, 0x000b0419, 
0xfff02087, 0xcdeff681, 0xbfeffb89, 0xcdfff681, 
0xcdeff68b, 0x000b5411, 0x1c080792, 0xfff01867, 
0xcdeff681, 0xbfeffb83, 0xcdfff080, 0x1c1e0fff, 
0x00097419, 0xcdfff28b, 0xbffe7b83, 0xcdfff681, 
0xcdeff681, 0xcfeff984, 0xcdeff28b, 0x0002a439, 
0xcffff884, 0xcfeff985, 0x0002a439, 0xcffff885, 
0xbfeffb82, 0x1c080392, 0x1ef90fff, 0x03f004f4, 
0x2f591ff2, 0xcdfff681, 0x1c000f08, 0xcdeff68b, 
0x3f322f92, 0x000b0419, 0x3f522f90, 0xfff02187, 
0xcdeff681, 0xcdfff681, 0xcdeff68b, 0x000b0419, 
0xfff02087, 0xcdeff681, 0x002fa459, 0xcffff987, 
0xbfeffb89, 0xcdfff681, 0xcdeff68b, 0x000b5411, 
0x1c080792, 0xfff01c47, 0xcdeff681, 0xbfeffb83, 
0x1c1e0fff, 0xcdfff080, 0x00097419, 0xcdfff28b, 
0xbfeffb81, 0xbfe80b82, 0x1c190fff, 0x1c090392, 
0x1ef97fff, 0x03f004ec, 0x2f380ff2, 0x1c000f00, 
0x3f122f92, 0xbfeffb84, 0x3f322f90, 0xbfe80b88, 
0x2b38ffe9, 0xf3588227, 0xcdfff681, 0xcdeff68b, 
0x1c77feef, 0xf4f884c7, 0xcdeff681, 0xcdfff681, 
0xcdeff28b, 0xcdeff681, 0xbffffb86, 0x002fa479, 
0xcffff987, 0xbfeffb84, 0xbfe80b89, 0x2b38ffe9, 
0xf3588407, 0xbfeffb83, 0xbfe80b84, 0x1f190fff, 
0xfff01c07, 0x1f370fef, 0xbffe7b83, 0xcdfff681, 
0xcdeff28b, 0xcdeff681, 0xbffffb84, 0xbffffb85, 
0xcfeff988, 0x0e02ab82, 0xfff01d27, 0xcffff988, 
0xbfeffb81, 0x1c080392, 0x1ef97fff, 0x03f004ec, 
0x2f380ff2, 0x1c000f00, 0x3f122f92, 0xbfeffb83, 
0xcdfff080, 0x3f322f90, 0x1c1e0fff, 0x00097419, 
0xcdfff28b, 0xbffe7b83, 0xbfeffb88, 0xcdfff681, 
0xcdeff68b, 0x2b78ffe9, 0xcdeff681, 0xf3588867, 
0xbfeffb86, 0x1c17feef, 0xf4d89247, 0xcdfff681, 
0xcdeff68b, 0x000b0419, 0xcdeff681, 0xfff02187, 
0x00097419, 0x002fa419, 0xcffff987, 0x000fa439, 
0xcffff884, 0xcfeff985, 0x0002a439, 0xcffff885, 
0xcdfff681, 0xcdeff68b, 0xfff02087, 0x000b0419, 
0x00800418, 0xffeff9d9, 0x00020419, 0x0809fbaa, 
0xf0d88c47, 0x0809fbca, 0xf0d88dc7, 0x0809fbea, 
0xf0d88f87, 0xf7d09167, 0xcfeff985, 0x00020419, 
0xcfeff983, 0x00027419, 0x1c19feff, 0xf0989167, 
0x000fa459, 0xffff39d9, 0x000fa439, 0x000f9419, 
0xf7f09167, 0xcffff985, 0xcfeff985, 0x00020419, 
0xcfeff983, 0x00027419, 0x1c19feff, 0xf0989167, 
0x000fa439, 0xffff39d9, 0xfff10527, 0xcfeff88e, 
0x000fa439, 0xcffff985, 0xf7f09167, 0x000f9419, 
0xcfeff985, 0x00020419, 0xcfeff982, 0x00027419, 
0x1c19feff, 0xf0989167, 0xfff10527, 0xceeff88e, 
0x000fa439, 0xcffff985, 0x9fefff0a, 0x9feffb09, 
0x1f1b7fff, 0x00a00438, 0x1ffffbdf, 0xbfeffb89, 
0xcdfff681, 0xcdeff68b, 0x000b5411, 0x1c080792, 
0xfff01867, 0xcdeff681, 0xbfeffb86, 0xcdfff681, 
0xcdeff68b, 0xbc1b7b84, 0xbffffb85, 0xcfeff988, 
0x0e02ab82, 0xfff01d27, 0xcffff988, 0xcfeff988, 
0x0c02aba2, 0xc7fff988, 0xcfeff988, 0x0c42ab82, 
0xc7fff988, 0x7c79ffbb, 0xf4d0a087, 0xbf863f7f, 
0x02a00c80, 0x3f796fd9, 0x1f167fef, 0x3f786fda, 
0xffffccf9, 0x00036401, 0xf7d0a027, 0xf7d096c7, 
0xf7d0a027, 0xf7d0a027, 0xf7d09867, 0xf7d09867, 
0xf7d09867, 0xf7d09947, 0xf7d09e87, 0xf7d09ea7, 
0xf7d09f27, 0xf7d09fa7, 0xf3f09747, 0x000f9419, 
0xf7f09767, 0x59ffffff, 0x5affffff, 0x71ffaeff, 
0xcffff987, 0xcfeff986, 0x0002f019, 0xf0f0a0e7, 
0x7ffc2f7f, 0x000fa479, 0xc7fff987, 0xdfef5988, 
0x0c12ab82, 0xcffff988, 0x7ffc2f7f, 0x000fa479, 
0x000f9419, 0xc7fff987, 0xcfeff988, 0x0c12ab82, 
0xcffff988, 0x002fa419, 0xcffff987, 0xcfeff884, 
0xcdfff080, 0xcdfff28b, 0xcdeff080, 0xbde2ab83, 
0xcdfff681, 0xcdeff68b, 0x1f782fff, 0xcdeff681, 
0xbffe7b83, 0xcffff984, 0xcfeff985, 0x0002a439, 
0xcffff985, 0xcfeff984, 0x00000430, 0x00300408, 
0x00023411, 0x180af792, 0xcfeff980, 0x3f322f9c, 
0x1c520fff, 0x1c33feef, 0xf0d09d27, 0x002fa439, 
0xcffff987, 0xcdfff681, 0xcdeff68b, 0x000b0419, 
0xfff02087, 0xcdeff681, 0xbfeffb8c, 0xcdfff681, 
0xcdeff68b, 0x1c080792, 0xfff01867, 0x000b5411, 
0xffd01d27, 0xcfeff988, 0x0c82ab82, 0xfff01d27, 
0xcffff988, 0xcfeff988, 0x0e02ab82, 0xfff01d27, 
0xcffff988, 0xcfeff988, 0x0d02ab82, 0xfff01d27, 
0xcffff988, 0xcfeff988, 0x0c02abc2, 0xc7fff988, 
0xcfeff988, 0x0c42ab82, 0xcffff988, 0x0fffffff, 
0x00800418, 0xfb77595b, 0x9faf2b09, 0x581027e5, 
0x4b1fffff, 0x9effeb0a, 0x00029409, 0xd73ff907, 
0xbfeffb87, 0x0f1d9fff, 0xcfeff108, 0x0802fbea, 
0xf0d8a467, 0x000fa479, 0xcffff108, 0x1eff1fff, 
0x1f5b3ff7, 0x001fa479, 0xcffff987, 0xbdec2b84, 
0x1ff00ff4, 0x7ff80f7f, 0xbffe7b83, 0xfff02187, 
0x3f532f92, 0xbfeffb81, 0x00089419, 0x0fffffff, 
0xdfef7987, 0x00200478, 0x00020419, 0x1c79feff, 
0xf4d0b747, 0xbf863f7f, 0x03000d00, 0x3f796fd9, 
0x1f167fef, 0x3f786fda, 0xffffccf9, 0x00036401, 
0xf7d0a787, 0xf7d0b747, 0xf7d0a787, 0xf7d0a787, 
0xf7d0a787, 0xf7d0a787, 0xf7d0a787, 0xf7d0a7c7, 
0xf7d0a787, 0xf7d0ac27, 0xf7d0b747, 0xf7d0b107, 
0x001fa479, 0xcffff987, 0x00000c00, 0x3f122f90, 
0xbfeffb83, 0x00082419, 0xcfeff884, 0xcdfff080, 
0xcdfff28c, 0xcdeff080, 0x0002a439, 0xcffff984, 
0xcfeff985, 0x0002a439, 0xcffff985, 0xcfeff984, 
0x00023411, 0xcfeff980, 0x1ef20fff, 0x1c33feef, 
0xf0d0aa67, 0x002fa439, 0xcffff987, 0xcdfff681, 
0xcdeff68c, 0x000b0419, 0xfff02187, 0xcdeff681, 
0xcdfff681, 0xcdeff68c, 0x000b0419, 0xfff02087, 
0xcdeff681, 0xcdfff681, 0xcdeff68c, 0x7f7e2f7f, 
0xaffe7b83, 0x00000c00, 0x3f122f90, 0xbfeffb83, 
0x00082419, 0xcfeff884, 0xcdfff080, 0xcdfff28c, 
0xcdeff080, 0x0002a439, 0xcffff984, 0xcfeff985, 
0x0002a439, 0xcffff985, 0xcdfff681, 0xcdeff68c, 
0x000b0419, 0xfff02187, 0xcdeff681, 0xcdfff681, 
0xcdeff68c, 0xfff02087, 0x000b0419, 0x002fa479, 
0xcffff987, 0xcfeff894, 0x00064419, 0xcfeff981, 
0x3f722f90, 0x3ff24bf4, 0x000b4439, 0xcdfff681, 
0xcdeff68c, 0x000b0419, 0xcdeff681, 0x2b79ffe8, 
0xf358b087, 0x00084409, 0x7f7e2f7f, 0xaffe7b83, 
0x00000c00, 0x3f122f90, 0xbfeffb83, 0xbfe82b84, 
0xcdfff080, 0x00080419, 0xfff02187, 0xcdfff28c, 
0x002fa419, 0xcffff987, 0x000fa439, 0xcffff984, 
0xcfeff985, 0x00023411, 0xcfeff981, 0x3ff20bf4, 
0x1f330fef, 0xf7f0b407, 0x0ff91bfa, 0xcdfff681, 
0xcdeff68c, 0x000b0419, 0xfff02087, 0xcdeff681, 
0xcfeff985, 0x0002a439, 0x1c52feff, 0xf4f8b367, 
0xcffff985, 0x00020419, 0xcfeff982, 0x00021419, 
0x1c59feff, 0xf098b627, 0x000fa439, 0xcefff985, 
0x9fefff0a, 0x9feffb09, 0x1f1b7fff, 0x00a00438, 
0x1ffffbdf, 0xcdfff681, 0xcdeff68c, 0x000b0419, 
0xfff02087, 0xcdeff681, 0xcdfff681, 0xcdeff68c, 
0x7f7e2f7f, 0xaffe7b83, 0xcfeff988, 0x0c42ab82, 
0xc7fff988, 0xbfeffb81, 0xbfefff83, 0x7c783f9f, 
0x0ffffffe, 0xcfeff980, 0x0002f019, 0xf0d0bb67, 
0xbfeffb85, 0xbfefff87, 0x1c1bfeff, 0xf490bb67, 
0xbfefff86, 0x1f1b4fff, 0x2fd47ffa, 0x1c087bb2, 
0x2b1bffee, 0xf358b9a7, 0x2fd87ff9, 0x1c08178a, 
0xbfeffb81, 0xbfefff82, 0x1c780fff, 0x1c597fff, 
0xbffffb8b, 0xf3f0bb27, 0x00082419, 0xf7f0bb47, 
0x49ffffff, 0x4affffff, 0x4ff1ff7f, 0x0fffffff, 
0x7ffffffd, 0xbfeffb89, 0xbffffb8a, 0xbffffb09, 
0xbfefff81, 0xbfeffb8b, 0x1c1b7fff, 0xbffffb8c, 
0xbfefff81, 0x9feffb09, 0x1f1b7fff, 0xbffffb81, 
0xbfefff85, 0xbfeffb86, 0x1f1b4fff, 0x2fd47ffa, 
0x1c087bb2, 0x2b1bffee, 0xf358bdc7, 0x2fd87ff9, 
0x1c08178a, 0xbfeffb81, 0xbfefff82, 0x1c780fff, 
0x1c597fff, 0xbffffb8b, 0xbfefff84, 0x7c783f9f, 
0xf7fa3cf9, 0x000e7419, 0xbffffb8d, 0xf3d0bfc7, 
0xf7f0bfe7, 0x4affffff, 0x49ffffff, 0xbfeffb85, 
0xbfefff89, 0x1c780fff, 0xbfefff87, 0x1c79feff, 
0xf490c147, 0xbfeffb87, 0x00080419, 0xcfeff981, 
0x0c02abc2, 0xcffff981, 0xbfeffb8d, 0x1f382fff, 
0xbfeffb86, 0x7f1e2eff, 0x4ff0ff7f, 0xf7f9fcf9, 
0xbfeffb85, 0xbfefff89, 0x1c780fff, 0xbfefff87, 
0x1c3bfeff, 0xf490c3c7, 0xbfefff8e, 0xbfeffb88, 
0xf3f0c387, 0x1f1b2fff, 0xf7f0c3a7, 0x49ffffff, 
0x4affffff, 0x4ff0ff7f, 0x0fffffff, 0x000e7419, 
0xbffffb8e, 0xbfeffb89, 0xbfefff8d, 0x1c7e0fff, 
0x1f384fff, 0xbfffff89, 0xbfeffb86, 0x1c1b7fff, 
0xbffffb89, 0xfff87cfb, 0xffdfccf9, 0xfb775cfb, 
0xf3f0c607, 0x581017e5, 0xf7f0c627, 0x4f5ffdff, 
0x4f3ffbff, 0xcfe8f60a, 0xbf1b7b81, 0xcfeafa86, 
0xbfefff85, 0x1f1b4fff, 0x2fd47ffa, 0x1c087bb2, 
0x4ff8ffff, 0x2b1bffee, 0xf358c747, 0x2fd87ff9, 
0xb3e81f82, 0xbfeffb81, 0x1c780fff, 0xbc597b8b, 
0xbfe80b84, 0x1c08478a, 0x7c793fdf, 0xf73ffcfb, 
0xf3d0c8e7, 0xf7f0c907, 0x4affffff, 0x49ffffff, 
0x7ffc2eff, 0x4ff0ff7f, 0xf7f87cfb, 0xf290c9a7, 
0xffd0bf27, 0xbfeffb89, 0x0008f019, 0xf0d0ca27, 
0xffd0b7a7, 0xffd0c207, 0xf290caa7, 0xffd0c3e7, 
0xffd0c207, 0xbfeffb8d, 0xfff0bf27, 0x00082419, 
0xffd0c3e7, 0x0fffffff, 0xcfeff981, 0x0c02aba2, 
0xfff0c3e7, 0xcffff981, 0xffd0bb87, 0xbfeffb88, 
0xbfefff85, 0x7c783f9f, 0x0fffff7e, 0xffdfccf9, 
0x0ffffe7e, 0xcfeff980, 0x0002f019, 0xf0d8cea7, 
0xbfefff80, 0xbfeffb88, 0x001b4439, 0x1fefffdf, 
0x1c782fff, 0x000d4419, 0x1c7efeff, 0xf498ce47, 
0xf7f0cea7, 0x48f1fe7f, 0xcfeff985, 0x0c02abc2, 
0xcffff985, 0xffdfccf9, 0xcfeff883, 0x00023411, 
0x00080419, 0xcfeff986, 0xf7f0d0e7, 0x00020411, 
0x03f00478, 0x3f794fd2, 0x77f10ea5, 0x00000438, 
0x3b71ffb2, 0x1ef33fe7, 0xf0f8d0c7, 0x1c090bd2, 
0xf7f0d0e7, 0x7ffffbff, 0x7ffffdff, 0x0003f009, 
0xf0d0cf87, 0x0fffffff, 0xbfeffb81, 0x00080419, 
0xbfeffb82, 0x00083411, 0x00034429, 0x1fe34bcf, 
0xffeff9d9, 0x1f1e1fff, 0x3ff28bd4, 0xcfeff982, 
0x0002a439, 0xcffff982, 0x00094419, 0x00027419, 
0xffeff9d9, 0x00024419, 0x1c78feff, 0xf4d8dd87, 
0xcfeff981, 0x00027419, 0xcfeff980, 0x00024419, 
0x1c78feff, 0xf090dbe7, 0xcfeff981, 0x0002a439, 
0x00297419, 0xcffff881, 0xcffff902, 0x00294439, 
0x1feffbdf, 0xbffffb82, 0xbfeffb88, 0x00394439, 
0x1fefffdf, 0x1c782fff, 0x000d4419, 0x1c7efeff, 
0xf498da07, 0xbfefff82, 0xffeff9d9, 0x3ff20bd4, 
0x00000438, 0x3b71ffb2, 0xf0d8d727, 0xf7f0d747, 
0x49ffffff, 0x4affffff, 0x4ff1fe7f, 0x000e1419, 
0xcfeff883, 0x00023411, 0xf7f0d9a7, 0x00080419, 
0x03f00478, 0x3f794fd2, 0x14010f86, 0x00000438, 
0x3b71ffb2, 0x1ef33fe7, 0x1c090bd2, 0xf0f8d967, 
0x000a2419, 0xf7f0d987, 0x49ffffff, 0x4affffff, 
0x4ff1fe7f, 0x0003f009, 0xf0d0d807, 0xf7d0e347, 
0xcfeff985, 0x0c12ab82, 0xcffff985, 0x00020419, 
0xcfeff884, 0x00024419, 0x2e7f4ff0, 0x2f79aff2, 
0xcffff10b, 0x2e1f4ff0, 0xcfeff00b, 0x2f787ff2, 
0x9ffffb0b, 0xf7f0e347, 0xfff87cfb, 0x00020419, 
0xcfeff884, 0x00024419, 0x2e7f4ff0, 0x2f79aff2, 
0xcffff10b, 0x2e1f4ff0, 0xcfeff00b, 0x2f787ff2, 
0x9ffffb0b, 0xfff87cfb, 0xcffff901, 0xf7d0e347, 
0xcfeff982, 0x1c72feff, 0xf090de87, 0x00134409, 
0xbfffff82, 0xffeff9d9, 0xf7f0dec7, 0x3ff20bd4, 
0xcfeff986, 0x00020411, 0x00000438, 0x3b71ffb2, 
0xf0f8df87, 0x000a2419, 0xf7f0dfa7, 0x49ffffff, 
0x4affffff, 0x00400418, 0x3b78ffb2, 0xf0f8e047, 
0x4ff0fe7f, 0xffff7cf9, 0xcfeff883, 0x00023411, 
0xf7f0e307, 0x00080419, 0x03f00478, 0x3f794fd2, 
0x14010f86, 0x00000438, 0x3b71ffb2, 0x1ef33fe7, 
0x1c090bd2, 0xf0f8e227, 0x000a2419, 0xf7f0e247, 
0x49ffffff, 0x4affffff, 0x77f88ee7, 0x00400418, 
0x3b78ffb2, 0xf0f8e307, 0x4ff0ff7f, 0xfeffbcf9, 
0x0003f009, 0xf0d0e0c7, 0x0fffffff, 0xfb775cfb, 
0xf3f8e407, 0x581037e5, 0xf7f0e427, 0x4a1ffdff, 
0x491ffbff, 0x4ff8ffff, 0x00020419, 0xcfeff884, 
0x00024419, 0x2e7f4ff0, 0x2f79aff2, 0xcffff10b, 
0x2e1f4ff0, 0xcfeff00b, 0x2f787ff2, 0x9ffffb0b, 
0xf398e667, 0xdf2ff60a, 0xbfeffb87, 0x1f1b7fff, 
0xbffffb88, 0xffd0cbe7, 0xffd0cc87, 0x0fffffff, 
0xf3d8e6e7, 0xf7f0e707, 0x4affffff, 0x49ffffff, 
0x4ff0ffff, 0x0c0c2e1e, 0x7ff20f7f, 0xcfeff884, 
0x00024419, 0x2e7f4ff0, 0x2f79aff2, 0xcffff10b, 
0x2e1f4ff0, 0xcfeff00b, 0x2f787ff2, 0x9ffffb0b, 
0xfff0cec7, 0x7ffffeff, 0xffd0cc87, 0x0fffffff, 
0xf310e947, 0xffd0e367, 0x9fefff0b, 0xbfeffb84, 
0x2b1bfff2, 0xf0d0f067, 0xcfeff10b, 0x00027419, 
0xcfeff984, 0x2b12fff2, 0xf0d0f067, 0xcfeff00b, 
0x00020419, 0xcfeff984, 0x2f32aff0, 0xcffff10b, 
0x00084419, 0xbfeffb84, 0x2f1b7ff0, 0x9ffffb0b, 
0x0c0faebe, 0xcffff902, 0xbfeffb80, 0xcffff881, 
0xbfeffb80, 0x00084439, 0x1feffbdf, 0xbffffb82, 
0xbfefff82, 0xffeff9d9, 0x3ff21bf4, 0xcfeff883, 
0x080afbba, 0x00020411, 0xf0f8edc7, 0x00083411, 
0xf7f0ede7, 0x7ffffbff, 0x7ffffdff, 0x03f00468, 
0xf7f0efc7, 0x3f398f92, 0x03f00460, 0x3f134f92, 
0x00037409, 0x1c0a1792, 0x1c087bd2, 0x080afbba, 
0x1ef10fe7, 0xf0f8efa7, 0x00083411, 0xf7f0efc7, 
0x7ffffbff, 0x7ffffdff, 0x0001f009, 0xf0d0ee47, 
0x00084401, 0xfff0d147, 0x000c2419, 0xcfeff985, 
0x0c02aba2, 0xcffff985, 0x0fffffff, 0xf310f127, 
0xffd0e367, 0xffd0d147, 0xf310f187, 0xffd0e367, 
0xcfeff985, 0x0c22ab82, 0xcffff985, 0xf3f8f267, 
0x7ffffefd, 0xf7f0f287, 0x7ffffdff, 0x7ffffbff, 
0x0c020e1e, 0xcfeff884, 0x00024419, 0x2e7f4ff0, 
0x2f79aff2, 0xcffff10b, 0x2e1f4ff0, 0xcfeff00b, 
0x2f787ff2, 0x9ffffb0b, 0x9feffb09, 0xbfefff88, 
0x1f1b7fff, 0xbffffb88, 0xffd0cbe7, 0xffd0cc87, 
0xffd0cec7, 0xf310f4e7, 0xffd0e367, 0x9feffb09, 
0xbfefff88, 0x1f1b7fff, 0xbffffb88, 0xffd0cbe7, 
0xffd0cc87, 0x0fffffff, 0xf310f607, 0xffd0e367, 
0xffff3cf9, 0xbfeffb88, 0xbfefff86, 0x7c783f9f, 
0xf7fbfcf9, 0xbfefff81, 0x4fffffff, 0x1feffb9f, 
0x1fe83fdf, 0x000b2419, 0xbfefff83, 0x00030419, 
0x1c3b3fff, 0x00037419, 0xbffffb84, 0x1f1e7fff, 
0xbffffb85, 0x7fffff9f, 0xcfeff881, 0x00287419, 
0x0002a439, 0xcffff881, 0x00023411, 0xcfeff980, 
0x00020419, 0x1c33feef, 0xf098fa47, 0xcffff901, 
0xbfeffb80, 0xbffffb81, 0x9feffb09, 0xbfefff83, 
0x1f1b7fff, 0xbffffb83, 0x0fffffff, 0xfb775cfb, 
0xf3f8fb07, 0x581017e9, 0xf7f0fb27, 0x4a3ffdff, 
0x495ffbff, 0xcfe8f60a, 0x4ff8ffff, 0x1f1b7fff, 
0xbffffb83, 0xbfeffb80, 0xbffffb81, 0xcffff901, 
0xfff0f6a7, 0xff3ffcfb, 0xfb775cfb, 0xf3f8fcc7, 
0x4ffff7ff, 0x6ffffdff, 0x6ffffbff, 0xf510fd27, 
0xffff3cf9, 0xf610fd67, 0xffff7cf9, 0xf3b8fe67, 
0x0ffffefe, 0x0fffff7e, 0xf3f0fe27, 0x4f5fffff, 
0x4f3fffff, 0xbfeffb85, 0x6ff83f9f, 0x0ffffffe, 
0x4fff0fff, 0xbfeffb86, 0x77f84ebf, 0x7f732f7f, 
0x6f133fdf, 0xf550ff67, 0xffff3cf9, 0xf650ffa7, 
0xffff7cf9, 0x0ffffe7e, 0xf3f10027, 0x4f3fffff, 
0x4f5fffff, 0xffd0f6a7, 0xf5910087, 0xffff3cf9, 
0xf69100c7, 0xffff7cf9, 0xbfeffb86, 0x77f80ebf, 
0x7f332f7f, 0xbfefff85, 0x1c7dfeff, 0xf4990267, 
0xf55101c7, 0xffff3cf9, 0xf6510207, 0xffff7cf9, 
0x0ffffe7e, 0xfff0f6a7, 0x4fff1fff, 0xbfeffb86, 
0x6f133fdf, 0xf3310307, 0x00090409, 0x0c090fa2, 
0xf2910347, 0x0c090fc2, 0xf2d10387, 0x0c190f82, 
0xf21103c7, 0x0c290f82, 0xf2510407, 0x0c490f82, 
0xf4110447, 0x0c890f82, 0xe3910487, 0x0d090f82, 
0xe3d104c7, 0x0e090f82, 0x9ff97b0c, 0xffffbcf9, 
0x47eff6bf, 0x00021411, 0x00071411, 0x00011411, 
0xffffccf9, 0x00001411, 0x000a7419, 0xcdfff28e, 
0x00077409, 0xcdfff28f, 0x00087409, 0xcdfff290, 
0xbfeffb88, 0x00287419, 0xbffffb88, 0xcfeff981, 
0x0002a439, 0xcffff981, 0x00020419, 0xcfeff980, 
0x00024419, 0x1c79feff, 0xf09908c7, 0xbfeffb87, 
0xbffffb88, 0xcffff901, 0x9feffb09, 0xbfefff81, 
0x1f1b7fff, 0xbffffb81, 0xbfefff88, 0x4fffffff, 
0xffeff899, 0x1fe82fdf, 0x000b3419, 0xcffff982, 
0x000e7419, 0xbffffb8c, 0x00037419, 0xbffffb8b, 
0x00080419, 0x2fd47ffa, 0x1c087bb2, 0x2b19ffee, 
0xf3590a87, 0x2fd87ff9, 0x1c08178a, 0xbfeffb81, 
0xbfefff8c, 0x1c780fff, 0x4f1f1fe5, 0x1c593fff, 
0xbfefff82, 0x7c733e9f, 0xcffff904, 0x0ffffe7e, 
0x0fffff7e, 0xcdeff290, 0x00088411, 0xcdeff28f, 
0x00087411, 0xcdefc28e, 0x00081419, 0x000a7419, 
0xcdfff291, 0x00077409, 0xcdfff292, 0x00087409, 
0xcdfff293, 0xbfefff8b, 0x2fd47ffa, 0x1c087bb2, 
0x2b1bffee, 0xf3590e27, 0x2fd87ff9, 0x1c08178a, 
0xbfeffb81, 0xbfefff8c, 0x1c780fff, 0x4fff1fff, 
0xf3f10f87, 0x1c593fff, 0xf7f10fa7, 0x4f3fffff, 
0x4f5fffff, 0x7dffaf9f, 0xcffff984, 0x0ffffe7e, 
0x0ffffffe, 0xcdeff293, 0x00088411, 0xcdeff292, 
0x00087411, 0xcdefc291, 0x00081419, 0xf3f11167, 
0x48f01ff1, 0xf7f11187, 0x4f5fffff, 0x4f3fffff, 
0xbfefff89, 0xbfeffb83, 0x7f1b2e7f, 0xbfeffb81, 
0xbfefff8c, 0x7c783f9f, 0x000fa459, 0xcffff984, 
0x0ffffefe, 0x0ffffffe, 0xffdfccf9, 0xf3f11367, 
0x4ff0ffe1, 0xf7f11387, 0x4affffff, 0x49ffffff, 
0xbfefff89, 0xbfeffb84, 0x7f1b2e7f, 0x000fa479, 
0xcffff984, 0x0ffffefe, 0x0fffff7e, 0xffdfccf9, 
0xf3f11507, 0x4ff00fed, 0xf7f11527, 0x4a3fffff, 
0x495fffff, 0xbfeffb86, 0x1f1e3fff, 0xbfeffb85, 
0x7f132e1f, 0x001fa419, 0xcffff984, 0x0ffffe7e, 
0x0fffff7e, 0xffdfccf9, 0xdb67560a, 0x9f0b0b09, 
0x5818f7ff, 0x1c197fff, 0xfff105c7, 0xdf3ff881, 
0x0fffffff, 0xbfefff88, 0x4fffffff, 0xffeff899, 
0x1fe82fdf, 0x000b3419, 0xcffff982, 0x000e7419, 
0xbffffb8c, 0x00037419, 0xbffffb8b, 0xf2991bc7, 
0xf2d91bc7, 0xcfeff984, 0x00023011, 0xf0d91a27, 
0x1ef3feef, 0xf0d91b27, 0x00000458, 0x1c73feef, 
0xf0d91b67, 0x00000478, 0x1c73feef, 0xf0d91b67, 
0x0fffffff, 0xbfeffb88, 0x00200408, 0xbc387b88, 
0xcfeff981, 0x1ef2afff, 0xfff105c7, 0xcffff981, 
0x0fffffff, 0xffd10ce7, 0x0fffffff, 0xbfeffb81, 
0xbfefff8c, 0x7c783fdf, 0x0fffffff, 0xcfef3986, 
0x0002f019, 0xf0d11ce7, 0xbfeffb8b, 0x0008f019, 
0xf0d91ce7, 0xffd10ce7, 0x0fffffff, 0xffd105c7, 
0x0fffffff, 0xfff110e7, 0xbff37b89, 0x0fffffff, 
0xf2d11fc7, 0x00034419, 0x1c7efeff, 0xf0d11e67, 
0xcfeff985, 0x0c02aba2, 0xcffff985, 0xbfeffb89, 
0xbc137b8a, 0xcfeff982, 0x0002f019, 0xf0d91f87, 
0xcffff903, 0xfff11487, 0x00032419, 0x0fffffff, 
0xffd105c7, 0x0fffffff, 0xffd112e7, 0x0fffffff, 
0xbfe2fa89, 0xf0f920e7, 0xbc137b8a, 0xcffff903, 
0xfff11487, 0x00032419, 0x0fffffff, 0xffd105c7, 
0x0fffffff, 0xbfeffb89, 0xbc1e7b8a, 0xcfeff985, 
0x0c02abc2, 0xcffff985, 0xcfeff982, 0x0002f019, 
0xf0d92287, 0xfff11487, 0xcffff903, 0x0fffffff, 
0xffd105c7, 0x0fffffff, 0xcfeff983, 0x0002a439, 
0xcffff983, 0x00020419, 0xcfeff982, 0x00021419, 
0x1c59feff, 0xf0912407, 0xffd11487, 0x0fffffff, 
0xffd105c7, 0x0fffffff, 0xfb775cfb, 0xf3f924e7, 
0x581007e5, 0xf7f12507, 0x495ffdff, 0x4a3ffbff, 
0xf3b92747, 0x4ff8ffff, 0xbfefff82, 0x1c7ffeff, 
0xf4912607, 0xcfeff986, 0x0802fbaa, 0xf0d12627, 
0x481fffff, 0x000fa439, 0xcffff984, 0xcffff983, 
0xbfeffb84, 0xbffffb85, 0xbfeffb81, 0xbf1c7b80, 
0x7ff82f7f, 0xff3ffcfb, 0x0fffffff, 0xcfeff983, 
0x0002a439, 0xcffff983, 0x00024419, 0xcfeff980, 
0x00020419, 0xcfeff981, 0x3f327bf4, 0x1c78feff, 
0xf49128e7, 0x000fa439, 0xcfff3983, 0xbfeffb82, 
0x00080419, 0x1c3ffeff, 0xf4912b87, 0xbfeffb81, 
0x00084419, 0x1c79feff, 0xf4912a87, 0xbc2b4b83, 
0x2b78ffe9, 0xf3592a27, 0xbdc74b81, 0xbc787b81, 
0xbfe80f82, 0x1c79feff, 0xf4912b87, 0xbc2b0b83, 
0x2b38ffe9, 0xf3592b27, 0xbdc74b81, 0xbf787b81, 
0xbfefff82, 0x1c7ffeff, 0xf4912c47, 0xcfeff986, 
0x0802fbaa, 0xf0d12c87, 0xf7f12d07, 0x481fffff, 
0xf3d92ce7, 0xf7f12d07, 0x495fffff, 0x4a3fffff, 
0xdfef5e81, 0xbfeffb80, 0x7f782f7f, 0x1c0b4792, 
0xbffe7b80, 0xcfeff984, 0xbc683f85, 0x080bfbda, 
0x7ff20fdf, 0xffeff8d9, 0x1c065602, 0x080bfbba, 
0x0000a419, 0x1c01a602, 0x00024419, 0x1c79feff, 
0xf0d12fc7, 0xcfeff885, 0xbdf87b85, 0x00024411, 
0x4bffffff, 0x7ffff9fe, 0xcfeff984, 0x0002a439, 
0xcffff984, 0x00027419, 0xcfeff982, 0x00024419, 
0x1c78feff, 0xf4d93147, 0x000fa439, 0xcffff984, 
0xbfeffb84, 0xbffffb85, 0x0fffffff, 0xdfefd983, 
0x00027419, 0xcfeff980, 0x00024419, 0x1c78feff, 
0xf4d132e7, 0xbfefff82, 0x1c7ffeff, 0xf49132e7, 
0xcfeff986, 0x0802fbaa, 0xf0d13307, 0x401fffff, 
0xf3d93347, 0x415fffff, 0x423fffff 

};

/***************************************************************** 
* List of eTPU functions included in this set
******************************************************************
"CAM",
"CRANK",
"CRANK_EMUL",
"FUEL",
"INJ",
"KNOCK",
"SPARK",
"TG",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
""
*/

#endif /* _ETPU_SET_H_ */

